/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.integration.jade.component_provider;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.integration.jade.ExposureJadePlugin;
import io.github.mortuusars.exposure.world.block.entity.LightroomBlockEntity;
import io.github.mortuusars.exposure.world.lightroom.PrintingMode;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ViewGroup;

public enum LightroomComponentProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig iPluginConfig) {
        class_1799 paper;
        class_2487 tag = accessor.getServerData();
        if (tag.method_10577("Empty")) {
            return;
        }
        IElementHelper helper = IElementHelper.get();
        tooltip.add(helper.spacer(0, 0));
        class_1799 film = class_1799.method_57359((class_7225.class_7874)accessor.getLevel().method_30349(), (class_2487)tag.method_10562("Film"));
        if (!film.method_7960()) {
            tooltip.append(helper.item(film));
            tooltip.append(helper.text((class_2561)class_2561.method_43470((String)"|").method_27692(class_124.field_1080)).size(new class_241(11.0f, 12.0f)).translate(new class_241(5.0f, 6.0f)).message(null));
        }
        if (!(paper = class_1799.method_57359((class_7225.class_7874)accessor.getLevel().method_30349(), (class_2487)tag.method_10562("Paper"))).method_7960()) {
            tooltip.append(helper.item(paper));
            tooltip.append(helper.text((class_2561)class_2561.method_43470((String)"+").method_27692(class_124.field_1080)).size(new class_241(12.0f, 12.0f)).translate(new class_241(5.0f, 6.0f)).message(null));
        }
        for (String dye : new String[]{"Cyan", "Yellow", "Magenta", "Black"}) {
            class_1799 stack = class_1799.method_57359((class_7225.class_7874)accessor.getLevel().method_30349(), (class_2487)tag.method_10562(dye));
            if (stack.method_7960()) continue;
            tooltip.append(helper.item(stack));
        }
        tooltip.append(helper.progress(tag.method_10583("Progress")));
        tooltip.append(helper.item(class_1799.method_57359((class_7225.class_7874)accessor.getLevel().method_30349(), (class_2487)tag.method_10562("Result"))));
        PrintingMode process = PrintingMode.fromStringOrDefault(tag.method_10558("Process"), PrintingMode.REGULAR);
        if (process != PrintingMode.REGULAR) {
            tooltip.add((IElement)helper.text((class_2561)class_2561.method_43471((String)("gui.exposure.lightroom.printing_mode." + process.method_15434()))));
        }
        tooltip.add(helper.spacer(0, 2));
    }

    public void appendServerData(class_2487 tag, BlockAccessor blockAccessor) {
        class_2586 class_25862 = blockAccessor.getBlockEntity();
        if (class_25862 instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)class_25862;
            if (lightroomBlockEntity.method_5442()) {
                tag.method_10556("Empty", true);
                return;
            }
            tag.method_10566("Film", lightroomBlockEntity.method_5438(0).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Paper", lightroomBlockEntity.method_5438(1).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Cyan", lightroomBlockEntity.method_5438(2).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Yellow", lightroomBlockEntity.method_5438(4).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Magenta", lightroomBlockEntity.method_5438(3).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Black", lightroomBlockEntity.method_5438(5).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10566("Result", lightroomBlockEntity.method_5438(6).method_57375((class_7225.class_7874)blockAccessor.getLevel().method_30349()));
            tag.method_10582("Process", lightroomBlockEntity.getActualPrintingMode().method_15434());
            tag.method_10548("Progress", lightroomBlockEntity.getProgressPercentage());
        }
    }

    public boolean shouldRequestData(BlockAccessor accessor) {
        return true;
    }

    public class_2960 getUid() {
        return ExposureJadePlugin.LIGHTROOM;
    }

    public static class EmptyItemStackExtensionProvider
    implements IServerExtensionProvider<class_1799>,
    IClientExtensionProvider<class_1799, ItemView> {
        public static final class_2960 ID = Exposure.resource("empty");
        public static final EmptyItemStackExtensionProvider INSTANCE = new EmptyItemStackExtensionProvider();

        private EmptyItemStackExtensionProvider() {
        }

        @Nullable
        public List<ViewGroup<class_1799>> getGroups(Accessor<?> accessor) {
            return Collections.emptyList();
        }

        public class_2960 getUid() {
            return ID;
        }

        public List<ClientViewGroup<ItemView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_1799>> list) {
            return Collections.emptyList();
        }
    }
}

